import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { useEditor, useValue } from "@tldraw/editor";
import { useActions } from "../../context/actions.mjs";
import { useCanRedo, useCanUndo } from "../../hooks/menu-hooks.mjs";
import { ColorSchemeMenu } from "../ColorSchemeMenu.mjs";
import { KeyboardShortcutsMenuItem } from "../HelpMenu/DefaultHelpMenuContent.mjs";
import { LanguageMenu } from "../LanguageMenu.mjs";
import {
  ClipboardMenuGroup,
  ConversionsMenuGroup,
  ConvertToBookmarkMenuItem,
  ConvertToEmbedMenuItem,
  EditLinkMenuItem,
  FitFrameToContentMenuItem,
  FlattenMenuItem,
  GroupMenuItem,
  RemoveFrameMenuItem,
  SelectAllMenuItem,
  ToggleAutoSizeMenuItem,
  ToggleDebugModeItem,
  ToggleDynamicSizeModeItem,
  ToggleEdgeScrollingItem,
  ToggleFocusModeItem,
  ToggleGridItem,
  ToggleLockMenuItem,
  TogglePasteAtCursorItem,
  ToggleReduceMotionItem,
  ToggleSnapModeItem,
  ToggleToolLockItem,
  ToggleTransparentBgMenuItem,
  ToggleWrapModeItem,
  UngroupMenuItem,
  UnlockAllMenuItem,
  ZoomTo100MenuItem,
  ZoomToFitMenuItem,
  ZoomToSelectionMenuItem
} from "../menu-items.mjs";
import { TldrawUiMenuGroup } from "../primitives/menus/TldrawUiMenuGroup.mjs";
import { TldrawUiMenuItem } from "../primitives/menus/TldrawUiMenuItem.mjs";
import { TldrawUiMenuSubmenu } from "../primitives/menus/TldrawUiMenuSubmenu.mjs";
function DefaultMainMenuContent() {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(EditSubmenu, {}),
    /* @__PURE__ */ jsx(ViewSubmenu, {}),
    /* @__PURE__ */ jsx(ExportFileContentSubMenu, {}),
    /* @__PURE__ */ jsx(ExtrasGroup, {}),
    /* @__PURE__ */ jsx(PreferencesGroup, {}),
    /* @__PURE__ */ jsx(HelpGroup, {})
  ] });
}
function ExportFileContentSubMenu() {
  const actions = useActions();
  return /* @__PURE__ */ jsxs(TldrawUiMenuSubmenu, { id: "export-all-as", label: "context-menu.export-all-as", size: "small", children: [
    /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "export-all-as-group", children: [
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["export-all-as-svg"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["export-all-as-png"] }),
      /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["export-all-as-json"] })
    ] }),
    /* @__PURE__ */ jsx(TldrawUiMenuGroup, { id: "export-all-as-bg", children: /* @__PURE__ */ jsx(ToggleTransparentBgMenuItem, {}) })
  ] });
}
function EditSubmenu() {
  const editor = useEditor();
  const selectToolActive = useValue(
    "isSelectToolActive",
    () => editor.getCurrentToolId() === "select",
    [editor]
  );
  return /* @__PURE__ */ jsxs(TldrawUiMenuSubmenu, { id: "edit", label: "menu.edit", disabled: !selectToolActive, children: [
    /* @__PURE__ */ jsx(UndoRedoGroup, {}),
    /* @__PURE__ */ jsx(ClipboardMenuGroup, {}),
    /* @__PURE__ */ jsx(ConversionsMenuGroup, {}),
    /* @__PURE__ */ jsx(MiscMenuGroup, {}),
    /* @__PURE__ */ jsx(LockGroup, {}),
    /* @__PURE__ */ jsx(TldrawUiMenuGroup, { id: "select-all", children: /* @__PURE__ */ jsx(SelectAllMenuItem, {}) })
  ] });
}
function MiscMenuGroup() {
  return /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "misc", children: [
    /* @__PURE__ */ jsx(GroupMenuItem, {}),
    /* @__PURE__ */ jsx(UngroupMenuItem, {}),
    /* @__PURE__ */ jsx(EditLinkMenuItem, {}),
    /* @__PURE__ */ jsx(ToggleAutoSizeMenuItem, {}),
    /* @__PURE__ */ jsx(RemoveFrameMenuItem, {}),
    /* @__PURE__ */ jsx(FitFrameToContentMenuItem, {}),
    /* @__PURE__ */ jsx(ConvertToEmbedMenuItem, {}),
    /* @__PURE__ */ jsx(ConvertToBookmarkMenuItem, {}),
    /* @__PURE__ */ jsx(FlattenMenuItem, {})
  ] });
}
function LockGroup() {
  return /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "lock", children: [
    /* @__PURE__ */ jsx(ToggleLockMenuItem, {}),
    /* @__PURE__ */ jsx(UnlockAllMenuItem, {})
  ] });
}
function UndoRedoGroup() {
  const actions = useActions();
  const canUndo = useCanUndo();
  const canRedo = useCanRedo();
  return /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "undo-redo", children: [
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["undo"], disabled: !canUndo }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["redo"], disabled: !canRedo })
  ] });
}
function ViewSubmenu() {
  const actions = useActions();
  return /* @__PURE__ */ jsx(TldrawUiMenuSubmenu, { id: "view", label: "menu.view", children: /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "view-actions", children: [
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-in"] }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-out"] }),
    /* @__PURE__ */ jsx(ZoomTo100MenuItem, {}),
    /* @__PURE__ */ jsx(ZoomToFitMenuItem, {}),
    /* @__PURE__ */ jsx(ZoomToSelectionMenuItem, {})
  ] }) });
}
function ExtrasGroup() {
  const actions = useActions();
  return /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "extras", children: [
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["insert-embed"] }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["insert-media"] })
  ] });
}
function HelpGroup() {
  function openUrl(url) {
    window.open(url, "_blank");
  }
  return /* @__PURE__ */ jsx(TldrawUiMenuGroup, { id: "help", children: /* @__PURE__ */ jsx(TldrawUiMenuSubmenu, { id: "help", label: "menu.help", children: /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "help-actions", children: [
    /* @__PURE__ */ jsx(KeyboardShortcutsMenuItem, {}),
    /* @__PURE__ */ jsx(
      TldrawUiMenuItem,
      {
        id: "about",
        label: "help-menu.docs",
        icon: "external-link",
        readonlyOk: true,
        onSelect: () => {
          openUrl("https://tldraw.dev");
        }
      }
    )
  ] }) }) });
}
function PreferencesGroup() {
  return /* @__PURE__ */ jsx(TldrawUiMenuGroup, { id: "preferences", children: /* @__PURE__ */ jsxs(TldrawUiMenuSubmenu, { id: "preferences", label: "menu.preferences", children: [
    /* @__PURE__ */ jsxs(TldrawUiMenuGroup, { id: "preferences-actions", children: [
      /* @__PURE__ */ jsx(ToggleSnapModeItem, {}),
      /* @__PURE__ */ jsx(ToggleToolLockItem, {}),
      /* @__PURE__ */ jsx(ToggleGridItem, {}),
      /* @__PURE__ */ jsx(ToggleWrapModeItem, {}),
      /* @__PURE__ */ jsx(ToggleFocusModeItem, {}),
      /* @__PURE__ */ jsx(ToggleEdgeScrollingItem, {}),
      /* @__PURE__ */ jsx(ToggleReduceMotionItem, {}),
      /* @__PURE__ */ jsx(ToggleDynamicSizeModeItem, {}),
      /* @__PURE__ */ jsx(TogglePasteAtCursorItem, {}),
      /* @__PURE__ */ jsx(ToggleDebugModeItem, {})
    ] }),
    /* @__PURE__ */ jsx(TldrawUiMenuGroup, { id: "color-scheme", children: /* @__PURE__ */ jsx(ColorSchemeMenu, {}) }),
    /* @__PURE__ */ jsx(TldrawUiMenuGroup, { id: "language", children: /* @__PURE__ */ jsx(LanguageMenu, {}) })
  ] }) });
}
export {
  DefaultMainMenuContent,
  EditSubmenu,
  ExportFileContentSubMenu,
  ExtrasGroup,
  HelpGroup,
  LockGroup,
  MiscMenuGroup,
  PreferencesGroup,
  UndoRedoGroup,
  ViewSubmenu
};
//# sourceMappingURL=DefaultMainMenuContent.mjs.map
